using System;
using System.Collections;
using System.Windows.Forms;
using DicomObjects;
using DicomObjects.EventArguments;

namespace Storage_Commitment_SCP
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : Form
	{

		public class OutstandingRequest
		{
			public DicomDataSet dataset;
			public string RemoteAET, LocalAET;
		}
		internal TextBox LogText;
		internal TextBox textBox3;
		internal ArrayList Requests;
		internal DicomServer Server;
		internal System.Timers.Timer MyTimer;
        private CheckBox Failure;
        private CheckBox EnableLog;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.LogText = new TextBox();
            this.textBox3 = new TextBox();
            this.Failure = new CheckBox();
            this.EnableLog = new CheckBox();
            this.SuspendLayout();
            // 
            // LogText
            // 
            this.LogText.BorderStyle = BorderStyle.FixedSingle;
            this.LogText.Location = new System.Drawing.Point(16, 79);
            this.LogText.Multiline = true;
            this.LogText.Name = "LogText";
            this.LogText.ScrollBars = ScrollBars.Vertical;
            this.LogText.Size = new System.Drawing.Size(600, 409);
            this.LogText.TabIndex = 3;
            // 
            // textBox3
            // 
            this.textBox3.BackColor = System.Drawing.SystemColors.Control;
            this.textBox3.BorderStyle = BorderStyle.FixedSingle;
            this.textBox3.Location = new System.Drawing.Point(16, 8);
            this.textBox3.Multiline = true;
            this.textBox3.Name = "textBox3";
            this.textBox3.Size = new System.Drawing.Size(600, 32);
            this.textBox3.TabIndex = 4;
            this.textBox3.TabStop = false;
            this.textBox3.Text = "This simple example handles Storage Commitment requests, and can send a notificat" +
                "ions on a new association (to localhost, port 105).  By default, this SCP respon" +
                "ds after 2 seconds.  ";
            // 
            // Failure
            // 
            this.Failure.AutoSize = true;
            this.Failure.Checked = true;
            this.Failure.CheckState = CheckState.Checked;
            this.Failure.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Failure.Location = new System.Drawing.Point(270, 52);
            this.Failure.Name = "Failure";
            this.Failure.Size = new System.Drawing.Size(128, 21);
            this.Failure.TabIndex = 5;
            this.Failure.Text = "Simulate Failure";
            this.Failure.UseVisualStyleBackColor = true;
            // 
            // EnableLog
            // 
            this.EnableLog.AutoSize = true;
            this.EnableLog.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.EnableLog.Location = new System.Drawing.Point(16, 52);
            this.EnableLog.Name = "EnableLog";
            this.EnableLog.Size = new System.Drawing.Size(220, 21);
            this.EnableLog.TabIndex = 6;
            this.EnableLog.Text = "Enable Live DicomObjects Log";
            this.EnableLog.UseVisualStyleBackColor = true;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(632, 510);
            this.Controls.Add(this.EnableLog);
            this.Controls.Add(this.Failure);
            this.Controls.Add(this.textBox3);
            this.Controls.Add(this.LogText);
            this.Name = "Form1";
            this.Text = "Form1";
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            this.Load += new System.EventHandler(this.Form1_Load);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			Server = new DicomServer();
			Server.NormalisedReceived +=Server_NormalisedReceived;                
			Server.DefaultStatus = 0xC000;
			Server.Listen(104);
            
			Requests = new ArrayList();
            // Put the following line back in to enbale DicomObjects logging
			//DicomGlobal.LogToFile("c:\\Dicom Log Files\\", 0x3F);
			MyTimer = new System.Timers.Timer(2000);
			MyTimer.Elapsed +=MyTimer_Elapsed;
			MyTimer.Enabled = false;
            DicomGlobal.EventLogLevel = (DicomObjects.Enums.LogLevel) 0x3F;
            DicomGlobal.LogEvent +=DicomGlobal_LogEvent;
		}



		private void Server_NormalisedReceived(object sender, NormalisedReceivedArgs e)
		{

			string AffectedSOPInstanceUID;
			long CommandField = Convert.ToInt64(e.RequestAssociation.Command[0x0000, 0x100].Value);
			int Status = 0xC000;
			string EventTypeID;

			Log("Incoming Operation Received : " + e.Operation.ToString());
			switch(CommandField)
			{
				case 0x130: // N-ACTION
					AffectedSOPInstanceUID = e.RequestAssociation.Command[0x0, 0x1001].Value.ToString();
					EventTypeID = e.RequestAssociation.Command[0x0, 0x1008].Value.ToString();
					// If not Storage Commitment Push then Error out
					if(AffectedSOPInstanceUID != DicomObjects.DicomUIDs.WellKnownInstances.StorageCommitmentPushModelInstance)
					{
						Status = 0x112; // Invalid object instance
					}
					else if(EventTypeID != "1")
					{
						Status = 0x123; // Invalid Action Type: 1 For Storage Commitment Request
					}
					else
					{
						// Send N-ACTION-RESP with success status
						// use RemoteAET to store the SCU's AET, which needs to be looked up from database						
						OutstandingRequest request = new OutstandingRequest
						    {
						        dataset = e.Request,
						        RemoteAET = e.RequestAssociation.CallingAET,
						        LocalAET = e.RequestAssociation.CalledAET
						    };

					    Requests.Add(request);
						Status = 0;
						MyTimer.Enabled = true;
					}
					break;
				default:
					Log("Invalid Command - " + CommandField.ToString("X4"));					
					break;
			}
			e.Status = Status;
		}
        private void Log(string s)
        {
            AppendText(LogText, s);
        }

        void DicomGlobal_LogEvent(LogEventArgs e)
        {
            if (EnableLog.Checked)
                AppendText(LogText, e.Text);
        }

        delegate void SetTextCallback(TextBox box, string text);

        private void AppendText(TextBox box, string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (box.InvokeRequired)
            {
                SetTextCallback d = AppendText;
                Invoke(d, new object[] { box, text });
            }
            else
            {
                box.Text = box.Text + text + "\r\n";
            }
        }

		private void MyTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			// Handle a single resonse
			// for a real application this would be triggered by confirmation that the images were "safe"
			// NOT by a timer
			if(Requests.Count > 0)
			{
				DicomAssociation cn2 = new DicomAssociation();
				OutstandingRequest request = Requests[Requests.Count - 1] as OutstandingRequest;

				DicomDataSet StorageCommitmentResult = new DicomDataSet();				
				
				DicomDataSetCollection OK_SOP_Sequence = new DicomDataSetCollection();
				DicomDataSetCollection Failed_SOP_Sequence = new DicomDataSetCollection();

				DicomDataSetCollection refSOPSQ; //Referenced SOP Sequence                
				refSOPSQ = request.dataset[0x8,0x1199].Value as DicomDataSetCollection;
				
				bool ImageOK = true;
				// Dummy Alternation here
				// replace the following foreach loop by Image Storage Status to indicate success or failure on each Image
				foreach(DicomDataSet ds in refSOPSQ)
				{
                    if (Failure.Checked)
                    {
                        if (ImageOK)
                        {
                            OK_SOP_Sequence.Add(ds);                            
                        }
                        else // Simulate Image Storage Failure
                        {
                            // Failure Reason
                            /*
                            0110H - Processing failure - A general failure in processing the operation was encountered.
                            0112H - No such object instance One or more of the elements in the Referenced SOP Instance Sequence was not available.
                            0213H - Resource limitation The SCP does not currently have enough resources to store the requested SOP Instance(s).
                            0122H - Referenced SOP Class not supported Storage Commitment has been requested for a SOP Instance with a SOP Class that is not supported by the SCP.
                            0119H - Class / Instance conflict The SOP Class of an element in the Referenced SOP Instance Sequence did not correspond to the SOP class registered for this SOP Instance at the SCP.
                            0131H - Duplicate transaction UID The Transaction UID of the Storage Commitment Request is already in use. 
                            */
                            ds.Add(0x0008, 0x1197, 0x110);
                            Failed_SOP_Sequence.Add(ds);                           
                        }
                        ImageOK = !ImageOK;
                    }
                    else 
                    {
                        OK_SOP_Sequence.Add(ds);
                    }
				}								
				
				int EventTypeID = 1; // 1 for success and 2 for failure, according to DICOM rules

				if(OK_SOP_Sequence.Count > 0)
				{
					EventTypeID = 1;
                    StorageCommitmentResult.Add(0x8, 0x1199, OK_SOP_Sequence);		// Referenced SOP Sequence
				}

				if(Failed_SOP_Sequence.Count > 0)
				{
					EventTypeID = 2;
                    StorageCommitmentResult.Add(0x8, 0x1198, Failed_SOP_Sequence); // Failed SOP Sequence	
				}

                StorageCommitmentResult.Add(0x8, 0x1195, request.dataset[0x8, 0x1195].Value); // Transaction UID
                StorageCommitmentResult.Add(0x8, 0x54, request.LocalAET);	// Retrieve AE Title, where images may be found

                cn2.RequestedContexts.Add(DicomObjects.DicomUIDs.SOPClasses.StorageCommitmentPush);
				cn2.RequestedContexts[1].RequestorSCURole = false;
				cn2.RequestedContexts[1].RequestorSCPRole = true;

				// Lookup RemoteAET in Database to find the associated IP address and Port number.
				// In this sample program, SCP is connecting directly to the follwing SCU:
				// == AET : SC_SCU
				// == IP  : Localhost
				// == Port: 105
				cn2.Open("localhost", 105, "SC_SCP", "SC_SCU");

				// Send N-EVENT-REPORT back on new Association
                cn2.NEventReport(DicomObjects.DicomUIDs.SOPClasses.StorageCommitmentPush,
                                 DicomObjects.DicomUIDs.WellKnownInstances.StorageCommitmentPushModelInstance,
                                 EventTypeID, StorageCommitmentResult);
				cn2.Close();
				
				Log("N-EVENT-REPORT Sent");
				Requests.Remove(request);				
			}
			MyTimer.Enabled = Requests.Count > 0; // Check to see if there is another to do
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			Server.UnlistenAll();
		}
	}
}
